
table task_list = tlist, task = task, task_link = tlink

s = varchar
t = text (in use?)
l = int
ts = timestamp
d = date
h = time
r = real

NOTE: field kind is omitted always from database structure = table name

https://developers.google.com/google-apps/tasks/v1/reference/tasklists?hl=fi#resource

{
  "kind": "tasks#taskList",
  "id": string,
  "etag": string,
  "title": string,
  "updated": datetime,
  "selfLink": string
}
DROP TABLE IF EXISTS task_list CASCADE;
CREATE TABLE task_list (
 id SERIAL primary key,
 etag varchar(60) NOT NULL DEFAULT '',
 title varchar(80) UNIQUE NOT NULL DEFAULT '',
 updated timestamp with time zone NOT NULL DEFAULT '1970-01-01 00:00:00+00',
 selfLink varchar(60) NOT NULL DEFAULT ''
);
DROP INDEX IF EXISTS task_list_id_idx;
CREATE INDEX task_list_id_idx ON task_list (id);
-- CREATE INDEX task_list_etag_idx ON task_list (etag);

	f = db.fieldTableAdd(conn, "task_list", "tlist", 
{{name="id", type="l"}, {name="etag", type="s", length=60}, {name="title", type="s", length=80}, {name="updated", type="ts"}, {name="selfLink", type="s", , length=60})


kind	string	Type of the resource. This is always "tasks#taskList".	
id	string	Task list identifier.	
etag	string	ETag of the resource.	
title	string	Title of the task list.	
selfLink	string	URL pointing to this task list. Used to retrieve, update, or delete this task list.	
updated	datetime	Last modification time of the task list (as a RFC 3339 timestamp).



table task

https://developers.google.com/google-apps/tasks/v1/reference/tasks?hl=fi
{
  "kind": "tasks#task",
  "id": string,
  "etag": etag,
  "title": string,
  "updated": datetime,
  "selfLink": string,
  "parent": string,
  "position": string,
  "notes": string,
  "status": string,
  "due": datetime,
  "completed": datetime,
  "deleted": boolean,
  "hidden": boolean,
  "links": [
    {
      "type": string,
      "description": string,
      "link": string
    }
  ]
}

DROP TABLE IF EXISTS task CASCADE;
CREATE TABLE task (
 id SERIAL primary key,
 task_list_id integer references task_list(id) NOT NULL,
 etag varchar(60) NOT NULL DEFAULT '',
 title varchar(80) NOT NULL DEFAULT '',
 updated timestamp with time zone NOT NULL DEFAULT '1970-01-01 00:00:00+00',
 selfLink varchar(60) NOT NULL DEFAULT '',
 parent varchar(80) NOT NULL DEFAULT '',
 position varchar(60) NOT NULL DEFAULT '',
 notes text NOT NULL DEFAULT '',
 status varchar(80) NOT NULL DEFAULT '',
 due timestamp with time zone NOT NULL DEFAULT '1970-01-01 00:00:00+00',
 completed timestamp with time zone NOT NULL DEFAULT '1970-01-01 00:00:00+00',
 deleted boolean NOT NULL DEFAULT false,
 hidden boolean NOT NULL DEFAULT false
);
DROP INDEX IF EXISTS task_id_idx;
CREATE INDEX task_id_idx ON task_list (id);


	f = db.fieldTableAdd(conn, "task_list", "task", 
{{name="id", type="l"}, {name="task_list_id", type="l"}, {name="etag", type="s", length=60}, {name="title", type="s", length=80}, {name="updated", type="ts"}, {name="selfLink", type="s", length=60}, {name="parent", type="s", length=80}, {name="position", type="s", length=60}, {name="notes", type="s"}, {name="status", type="s", length=80}, {name="due", type="ts"}, {name="completed", type="ts"}, {name="deleted", type="b"}, {name="hidden", type="b"}})

kind	string	Type of the resource. This is always "tasks#task".	
id	string	Task identifier.	
etag	etag	ETag of the resource.	
title	string	Title of the task.	
updated	datetime	Last modification time of the task (as a RFC 3339 timestamp).	
selfLink	string	URL pointing to this task. Used to retrieve, update, or delete this task.	
parent	string	Parent task identifier. This field is omitted if it is a top-level task. This field is read-only. Use the "move" method to move the task under a different parent or to the top level.	
position	string	String indicating the position of the task among its sibling tasks under the same parent task or at the top level. If this string is greater than another tasks corresponding position string according to lexicographical ordering, the task is positioned after the other task under the same parent task (or at the top level). This field is read-only. Use the "move" method to move the task to another position.	
notes	string	Notes describing the task. Optional.	
status	string	Status of the task. This is either "needsAction" or "completed".	
due	datetime	Due date of the task (as a RFC 3339 timestamp). Optional.	
completed	datetime	Completion date of the task (as a RFC 3339 timestamp). This field is omitted if the task has not been completed.	
deleted	boolean	Flag indicating whether the task has been deleted. The default if False.	
hidden	boolean	Flag indicating whether the task is hidden. This is the case if the task had been marked completed when the task list was last cleared. The default is False. This field is read-only.	



table task_links
  "links": [
    {
      "type": string,
      "description": string,
      "link": string
    }

DROP TABLE IF EXISTS task_link CASCADE;
CREATE TABLE task_link (
 id SERIAL primary key,
 task_id integer references task(id),
 type varchar(60) NOT NULL DEFAULT '',
 description varchar(80) NOT NULL DEFAULT '',
 link varchar(80) NOT NULL DEFAULT ''
);
DROP INDEX IF EXISTS task_links_id_idx;
CREATE INDEX task_links_id_idx ON task_link (id);

	f = db.fieldTableAdd(conn, "task_list", "tlink", 
{{name="id", type="l"}, {name="task_id", type="l"}, {name="type", type="s", length=60}, {name="description", type="s", length=80},
 {name="link", type="s", length=80}})

links[]	list	Collection of links. This collection is read-only.	
links[].type	string	Type of the link, e.g. "email".	
links[].description	string	The description. In HTML speak: Everything between <a> and </a>.	
links[].link	string	The URL.

